using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Xanthos.Interfaces;
using Xanthos.ShrinkSystem;

namespace Server.Items
{
	public class Naramek : GoldBracelet, IShrinkTool
	{
		public override int ArtifactRarity{ get{ return 100; } }
		private int m_Charges = 1;
		private int m_ManaStored = 0;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int ShrinkCharges
		{
			get { return m_Charges; }
			set
         {
            if ( m_Charges > 10 )
               m_Charges = 10;
            
            m_Charges = value;
         }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int ManaStored
		{
			get { return m_ManaStored; }
			set
         {
            if ( value > 400 )
               value = 400;
               
            if ( value < 0 )
               value = 0;
            
            m_ManaStored = value;
            InvalidateProperties();
         }
		}
		
		[Constructable]
		public Naramek() : base()
		{
			Name = "Naramek";
			Hue = 1165;
			LootType = LootType.Blessed;
			Attributes.BonusDex = 10;
			Attributes.BonusInt = 10;
			Attributes.BonusStr = 10;
			Attributes.CastRecovery = 3;
			Attributes.CastSpeed = 3;
			Attributes.LowerManaCost = 20;
			Attributes.Luck = 500;
			Attributes.RegenHits = 3;
			Attributes.RegenMana = 3;
			Attributes.RegenStam = 3;
			
			SkillBonuses.SetValues( 0, SkillName.AnimalTaming, 10.0 );
			SkillBonuses.SetValues( 1, SkillName.AnimalLore, 10.0 );
		}
		
		public override void OnDoubleClick( Mobile m )
		{
			if( m.HasTrade )
			{
				m.SendMessage( "Nemuzes naramek pouzit pokud s nekym obchodujes!" );
			}
			else if( Parent == m ) //Mana Store
			{
				int mn, ms;
				
            if ( m.Mana >= m.ManaMax )
				{
               if ( m_ManaStored < 400 )
               {
                  mn = ( 400 - m_ManaStored );
                  ms = ( ( m.Mana > mn ) ? mn : m.Mana );
                  m_ManaStored += ms;
                  m.Mana -= ms;
                  m.SendMessage( "{0} many bylo ulozeno do naramku.", ms );
				      m.FixedParticles( 0x3779, 10, 15, 5004, EffectLayer.Head );
				      m.PlaySound( 0x1E4 );
				      InvalidateProperties();
               }
               else
                  m.SendMessage( "Vice mana energie naramek nepojme!" );
            }
            else
            {
               if ( m_ManaStored > 0 )
               {
                  mn = ( ( m.ManaMax - m.Mana ) + m_ManaStored );
                  ms = ( ( mn > m.ManaMax ) ? ( m.ManaMax - m.Mana ) : mn );
                  m_ManaStored -= ms;
                  m.Mana += ms;
                  m.SendMessage( "Z naramku bylo vyjmuto {0} many.", ms );
				      m.FixedParticles( 0x375A, 10, 15, 5011, EffectLayer.Head );
				      m.PlaySound( 0x1EB );
				      InvalidateProperties();
               }
               else
                  m.SendMessage( "V naramku neni ulozena zadna mana energie!" );
            }
			}
			else if ( IsChildOf( m.Backpack ) ) //Shrink
			{
				bool isStaff = m.AccessLevel != AccessLevel.Player;

				if ( isStaff || m.Skills[ SkillName.AnimalTaming ].Value >= ShrinkConfig.TamingRequired )
				{
					m.Target = new ShrinkTarget( m, this, isStaff );
					m_Charges++;
				}
				else
					m.SendMessage( "You must have at least " + ShrinkConfig.TamingRequired + " animal taming to use a this bracelet." );
			}
		}

		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#33FF66>Shrink Tool\nMana Stored: {0}/400<basefont color=White>", m_ManaStored );
		}

		public Naramek( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 1 );
			writer.Write( m_Charges );
			writer.Write( m_ManaStored );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			m_Charges = reader.ReadInt();
			m_ManaStored = reader.ReadInt();
		}
	}
}
